/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.ResultSetRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.Template;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.Server;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class StoreResponder
extends Responder {
    private static final int MAX_FILE_SIZE = 0x100000;
    protected InterpartsServer m_interpartsServer;
    protected DatabaseManager m_databaseManager;
    protected String m_prequeryTemplate;
    protected Properties m_queryTemplates;
    protected String m_storePassword;
    protected String[][] m_storeAccessMask;
    protected Document m_document;
    protected boolean m_accessAllowed;
    protected boolean m_stored;
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$StoreResponder == null ? (class$com$belenus$interpartsserver3$StoreResponder = StoreResponder.class$("com.belenus.interpartsserver3.StoreResponder")) : class$com$belenus$interpartsserver3$StoreResponder));
    static /* synthetic */ Class class$com$belenus$interpartsserver3$StoreResponder;

    public StoreResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
        this.m_interpartsServer = (InterpartsServer)this.m_server;
        this.m_databaseManager = this.m_interpartsServer.getDatabaseManager();
        this.m_prequeryTemplate = this.m_interpartsServer.m_storePrequery;
        this.m_queryTemplates = this.m_interpartsServer.m_storeQueries;
        this.m_storePassword = this.m_interpartsServer.m_storePassword;
        this.m_storeAccessMask = this.m_interpartsServer.m_storeAccessMask;
        this.m_accessAllowed = false;
        this.m_stored = false;
    }

    protected void respond() throws Exception {
        if (this.m_storePassword != null && !this.m_storePassword.equals("") && this.m_serverDispatcher.allowedAccess(this.m_httpServletRequest, this.m_storeAccessMask)) {
            boolean isMultipartContent = FileUpload.isMultipartContent((HttpServletRequest)this.m_httpServletRequest);
            String password = this.m_httpServletRequest.getParameter("password");
            if (isMultipartContent) {
                DiskFileUpload diskFileUpload = new DiskFileUpload();
                diskFileUpload.setSizeMax(0x100000L);
                List fileItems = diskFileUpload.parseRequest(this.m_httpServletRequest);
                ParameterContainer parameterContainer = new ParameterContainer(this.m_httpServletRequest, this.m_configurator);
                for (int fileItemsIndex = 0; fileItemsIndex < fileItems.size(); ++fileItemsIndex) {
                    FileItem fileItem = (FileItem)fileItems.get(fileItemsIndex);
                    String fieldName = fileItem.getFieldName();
                    if (!fileItem.isFormField()) continue;
                    String fieldValue = fileItem.getString();
                    parameterContainer.setRequestVariable(fieldName, fieldValue);
                    if (password != null || !"password".equals(fieldName)) continue;
                    password = fieldValue;
                }
                if (this.m_storePassword.equals(password)) {
                    this.store(fileItems);
                }
            } else {
                logger.warn((Object)"No multipart content.");
                this.m_httpServletResponse.sendError(406, "No multipart content");
                return;
            }
        }
        if (!this.m_accessAllowed) {
            logger.warn((Object)"Unauthorized access to StoreResponder");
            this.m_httpServletResponse.sendError(403, "Access not allowed");
        } else if (!this.m_stored) {
            logger.info((Object)"StoreResponder had error");
            this.m_httpServletResponse.sendError(500, "Could not store data");
        } else {
            logger.info((Object)"StoreResponder finished");
            OutputStream outputStream = this.startOutputStream(false, false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("<html><head><title>Data Stored</title></head><body>Data has been stored.</body></html>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void store(List fileItems) throws IOException, DocumentException {
        block11: {
            this.m_accessAllowed = true;
            this.m_databaseManager.startTransaction();
            if (this.m_prequeryTemplate != null) {
                ParameterContainer parameterContainer = new ParameterContainer(this.m_httpServletRequest, this.m_configurator);
                Template template = new Template(this.m_prequeryTemplate, parameterContainer);
                ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
                Row row = rowContainer.nextRow();
                if (row != null) {
                    parameterContainer.setFixedResponderVariables(row);
                }
                rowContainer.destroy();
            }
            for (int fileItemsIndex = 0; fileItemsIndex < fileItems.size(); ++fileItemsIndex) {
                InputStream inputStream;
                FileItem fileItem = (FileItem)fileItems.get(fileItemsIndex);
                if (fileItem.isFormField() || (inputStream = fileItem.getInputStream()) == null) continue;
                this.storeInDatabase(inputStream);
            }
            this.m_stored = true;
            Object var7_8 = null;
            try {
                this.m_databaseManager.finishTransaction();
            }
            catch (Exception exc2) {
                logger.error((Object)exc2, (Throwable)exc2);
            }
            break block11;
            {
                catch (Exception exc) {
                    logger.error((Object)exc, (Throwable)exc);
                    Object var7_9 = null;
                    try {
                        this.m_databaseManager.finishTransaction();
                    }
                    catch (Exception exc2) {
                        logger.error((Object)exc2, (Throwable)exc2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    this.m_databaseManager.finishTransaction();
                }
                catch (Exception exc2) {
                    logger.error((Object)exc2, (Throwable)exc2);
                }
                throw throwable;
            }
        }
    }

    private void storeInDatabase(InputStream inputStream) throws DocumentException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.showBufferedInputStream(bufferedInputStream);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)bufferedInputStream);
        Element dataElement = document.getRootElement();
        List elements = dataElement.elements();
        for (int elementsIndex = 0; elementsIndex < elements.size(); ++elementsIndex) {
            Element queryElement = (Element)elements.get(elementsIndex);
            this.storeInDatabase(queryElement);
        }
    }

    private void storeInDatabase(Element queryElement) {
        String queryElementName = queryElement.getName();
        String queryTemplate = this.m_queryTemplates.getProperty(queryElementName);
        if (queryTemplate != null) {
            List rowElements = queryElement.elements();
            for (int rowElementsIndex = 0; rowElementsIndex < rowElements.size(); ++rowElementsIndex) {
                Element rowElement = (Element)rowElements.get(rowElementsIndex);
                ParameterContainer parameterContainer = new ParameterContainer(this.m_httpServletRequest, this.m_configurator);
                parameterContainer.clearResponderVariables();
                List fieldElements = rowElement.elements();
                for (int fieldElementsIndex = 0; fieldElementsIndex < fieldElements.size(); ++fieldElementsIndex) {
                    Element fieldElement = (Element)fieldElements.get(fieldElementsIndex);
                    String fieldElementName = fieldElement.getName();
                    String fieldElementText = fieldElement.getText();
                    parameterContainer.setResponderVariable(fieldElementName, fieldElementText);
                }
                Template template = new Template(queryTemplate, parameterContainer);
                ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
                rowContainer.destroy();
            }
        } else {
            throw new RuntimeException("No known query for element " + queryElementName);
        }
    }

    private void showBufferedInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        int newLength;
        bufferedInputStream.mark(0x100000);
        byte[] buffer = new byte[1024];
        int length = newLength = bufferedInputStream.read(buffer);
        while (newLength != -1) {
            System.out.print(new String(buffer, 0, newLength));
            newLength = bufferedInputStream.read(buffer);
            length += newLength;
        }
        System.out.println();
        System.out.println("Length: " + length);
        bufferedInputStream.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

